<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use MongoDB\Laravel\Eloquent\Model as MongoModel;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Tag extends MongoModel
{

    protected $fillable = [
        'title',
    ];

    public function entries(): BelongsToMany {
        return $this->belongsToMany(Entry::class, null, 'tag_ids', 'entry_ids');
    }

}
